﻿///
/// 7-Zip の格納ファイルやアーカイブのプロパティを変換する関数のヘッダファイル。
/// Internal: 非公開
///

#if       !defined(INCLUDED_SZ_PROPERTY_CONVERSIONS)
#define            INCLUDED_SZ_PROPERTY_CONVERSIONS

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

#if       !defined(INCLUDED_SZ_TIME)
#include  <szTime.hpp>
#endif // !defined(INCLUDED_SZ_TIME)

#include  <Windows/PropVariant.h>

struct IInArchive;

SZ_NS_BEG(szpp)

// このような関数については 7-Zip の OpenArchive.cpp, ArchiveExtractCallback.cpp あたりを参照。

szstring ConvertPropVariantToString(const NWindows::NCOM::CPropVariant &propVariant);
u64      ConvertPropVariantToU64(const NWindows::NCOM::CPropVariant &propVariant);
u32      ConvertPropVariantToU32(const NWindows::NCOM::CPropVariant &propVariant);
bool     ConvertPropVariantToBool(const NWindows::NCOM::CPropVariant &propVariant);
Time     ConvertPropVariantToTime(const NWindows::NCOM::CPropVariant &propVariant);

szstring GetStringProperty(IInArchive *archive, index_t index, PROPID propID);
u64      GetU64Property(IInArchive *archive, index_t index, PROPID propID);
u32      GetU32Property(IInArchive *archive, index_t index, PROPID propID);
bool     GetBoolProperty(IInArchive *archive, index_t index, PROPID propID);
Time     GetTimeProperty(IInArchive *archive, index_t index, PROPID propID);

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_PROPERTY_CONVERSIONS)
